/*
    This model is intended for saving newly created request scheduling appointments.

    [POST] {base}/rest/appointment-service/patient/{assigning-authority}/{patient-id}/appointments

        Unfortunately, the expectations of this endpoint is not well document and the data provided through
        this model, is base on what has historically been passed to the endpoint opposed to any specific design
        specification.  Hopefully, sometime in the future the exact API specification can be flushed out and
        this model can be updated accordingly.
 */
define([
    'underscore',
    'backbone',
    'modules/new-appointment-request/resources/common/model',
], function(_, Backbone, Model) {
    'use strict';

    return Model.extend({
        resourceName: 'appointment-requests',

        getUrl: function() {
            var resource = this.getResource();
            var idType = this.getUserIdType();
            var id = this.getUserId();

            return resource.formatHref({
                'assigning-authority': idType,
                'patient-id': id,
            });
        },

        // TODO clean up
        createSaveData: function() {
            var model = this.clone();
            var typeOfCare;
            var requestFacility;
            var institution;
            var siteCode;
            var attributes;

            model = this.setRequestTimes(model);

            typeOfCare = model.getCareId();
            model.set('typeOfCareId', typeOfCare);
            model.set('typeOfCare', typeOfCare);

            if (!model.get('visitType')) {
                model.set('visitType', 'Office Visit');
            }

            if (!model.get('requestedPhoneCall')) {
                model.set('requestedPhoneCall', false);
                model.set('providerOption', '');
            } else {
                model.set('providerOption', 'Call before booking appointment');
            }

            if (this.isExpressCare()) {
                model.set({
                    reasonForVisit: model.get('reasonForVisit') === 'ZZ' ? 'Other' : model.get('reasonForVisit'),
                });
            }

            requestFacility = new Backbone.Model();
            siteCode = model.getSiteCode();
            institution = model.facility();

            requestFacility.set('facilityCode', model.getInstitutionCode());
            requestFacility.set('parentSiteCode', siteCode);
            requestFacility.set('name', institution.get('authoritativeName'));
            requestFacility.set('state', institution.get('stateAbbrev'));
            requestFacility.set('city', institution.get('city'));

            model.set('facility', requestFacility);

            model.unset('pacTeam');

            attributes = model.toJSON();

            attributes.email = model.getEmail().email;

            return attributes;
        },

        // TODO clean up
        setRequestTimes: function(model) {
            var maxTimes = 4;
            var date;
            var time;
            var i;

            for (i = 1; i < maxTimes; i++) {
                date = 'optionDate' + i;
                time = 'optionTime' + i;

                if (model.get(date) && _.isDateString(model.get(date))) {
                    if (!model.get(time)) {
                        model.set(time, 'AM');
                    }
                } else {
                    model.set(date, 'No Date Selected');
                    model.set(time, 'No Time Selected');
                }
            }
            return model;
        },
    });
});
